const companyModel = require('../model/company');
const mediaModel = require('../model/projectMedia');

const helper = require('../middleware/_helper');
const mediaUtils = require("../config/unlinkMedia");

const path = require("path");
var fs = require("fs");
const fse = require('fs-extra')

/// Create and Save a new Company
exports.create = (req, res) => {
    console.log("Company Body data", req.body)
    // Validate request
    if (!req.body.company_name) {
        return res.status(400).send({"is_error": true , "message": "Please provide the name of company."});
      }

    // Create a Company
    const companyRecord = new companyModel({
        company_name: req.body.company_name , 
        email: req.body.email,
        phone: req.body.phone,
        address_line: req.body.address_line,
        country: req.body.country,
        state: req.body.state,
        city: req.body.city,
        zip_code: req.body.zip_code,
        company_logo: req.body.company_logo,
        about_us: req.body.about_us,
        privacy_policy: req.body.privacy_policy,
        terms_and_conditions: req.body.terms_and_conditions,
    });

    // Save Company in the database
    companyRecord.save()
    .then(data => {
        res.send({is_error : false, data: data });
    }).catch(err => {
        return res.status(500).send({
            is_error : true,
            message: err.message || "Some error occurred while creating the Company."
        });
    });
};

// Retrieve and return all Companies from the database.
exports.findAll = async (req, res) => {
    try {
        const page = await companyModel.find({is_deleted: false}).sort([["updatedAt",-1]]);
        res.send({is_error : false, data: page});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a single Company Details with a id
exports.findOne = (req, res) => {
    companyModel.findById(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Company details not found with id " + req.params.id
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Company details not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving Company details with id " + req.params.id
        });
    });
};


// Update Company details
exports.update = (req, res) => {

console.log("req.body", req.body)
  // Validate request
  if (!req.body.company_name) {
    return res.status(400).send({"is_error": true , "message": "Please provide Company name."});
  }

// Create a Company
const companyRecord = {
    company_name: req.body.company_name , 
    email: req.body.email,
    phone: req.body.phone,
    address_line: req.body.address_line,
    country: req.body.country,
    state: req.body.state,
    city: req.body.city,
    zip_code: req.body.zip_code,
    company_logo: req.body.company_logo,
    about_us: req.body.about_us,
    privacy_policy: req.body.privacy_policy,
    terms_and_conditions: req.body.terms_and_conditions,
};


    // Find Company and update it with the request body
    companyModel.findByIdAndUpdate(req.params.id, companyRecord, {new: true})
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Company not found with id " + req.params.id
            });
        }
        res.send( { is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Company not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error updating Company with id " + err
        });
    });
};

// Delete a Company with the specified id in the request
exports.delete = (req, res) => {
    companyModel.findByIdAndRemove(req.params.id)
    .then(responseData => {
        if(!responseData) {
            return res.status(404).send({
                is_error : true,
                message: "Company not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Company deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.company_name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Company not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Company with id " + req.params.id
        });
    });
};

// Change project status
exports.changeStatus = async (req, res) => {

    await companyModel.findByIdAndUpdate(req.params.company_id, {
        is_active: req.body.is_active
    }, { new: true })
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Company Details."
                });
            }
            const notifyMsg = req.body.is_active ? 'Opened' : 'Closed';
            res.send({'message': 'Company has been marked as' +' '+ notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Company details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the Company status."
            });
        });
};