var slugify = require('slugify')
const groupModel = require('../model/facilities');
const helper = require('../middleware/_helper');

// Add Amenities/ Facility
exports.addAmenities = async (req, res) => {
    console.log("Group Body data", req.body)
    // Validate request
    if (!(req.body.name)) {
        return res.status(400).send({ "is_error": true, "message": "Amenities name can't be empty." });
    }
    if (!(req.body.facility_type)) {
        return res.status(400).send({ "is_error": true, "message": "Please select facility type." });
    }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    if (loggedInUser && loggedInUser.data && loggedInUser.data.user_id) {
        // check if Group already exist
        // Validate if Group exist in our database
        const isDataExist = await groupModel.findOne({ 'name': req.body.name ,'created_by': loggedInUser.data.user_id, 'parent': null });

        if (isDataExist) {
        return res.status(409).send({"is_error": true , "message":  req.body.name + "Already Exist" });
        }
        // Create a Facility Payload
        const groupDataPayload = new groupModel({
            name: req.body.name,
            facility_type: req.body.facility_type,
            description: req.body.description,
            created_by: loggedInUser.data.user_id
        });

        // Save Group in the database
        groupDataPayload.save()
            .then(data => {
                res.send({ is_error: false, data: data });
            }).catch(err => {
               return res.status(500).send({
                    is_error: true,
                    message: err.message || "Some error occurred while creating the Amenities."
                });
            });
    }
};

exports.update = (req, res) => {
    console.log("req.body", req.body);
    console.log("req.params", req.params)
    // Validate Request
    // Validate request
    if (!(req.body.name)) {
       return res.status(400).send({ "is_error": true, "message": "Amenities name can't be empty." });
    }
    if (!(req.body.facility_type)) {
        return res.status(400).send({ "is_error": true, "message": "Please select facility type." });
    }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    if (loggedInUser && loggedInUser.data && loggedInUser.data.user_id) {
        // Create a Facility Payload
        const catData = new groupModel({
            name: req.body.name,
            facility_type: req.body.facility_type,
            description: req.body.description,
            created_by: loggedInUser.data.user_id
        });
    }

    // Find facility and update it with the request body
    groupModel.findOneAndUpdate({ _id: req.params.id, created_by: loggedInUser.data.user_id }, {
        name: req.body.name,
        facility_type: req.body.facility_type
    }, { new: true })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Amenities not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Amenities not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating Amenities Deatails " + err
            });
        });
};

// Get all DB Amenities
exports.getAllAmenities = async (req, res) => {
    try {
        const GroupData = await groupModel.find({ parent: { $eq: null } })
        .populate({path:'facility_type'})
        .sort([["updatedAt",-1]]);
        res.send({ is_error: false, data: GroupData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};
