var slugify = require('slugify')
const groupModel = require('../model/facilities_type');
const helper = require('../middleware/_helper');

// Add facility group
exports.addgroup = async (req, res) => {
    console.log("Group Body data", req.body)
    // Validate request
    if (!(req.body.group_name)) {
        return res.status(400).send({ "is_error": true, "message": "All input is required" });
    }
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    if (loggedInUser && loggedInUser.data && loggedInUser.data.user_id) {
        // check if Group already exist
        // Validate if Group exist in our database
        const isDataExist = await groupModel.findOne({ 'group_name': req.body.group_name ,'created_by': loggedInUser.data.user_id, 'parent': null });

        if (isDataExist) {
        return res.status(409).send({"is_error": true , "message":  req.body.group_name + " Group Already Exist" });
        }
        // Create a Group
        const groupDataPayload = new groupModel({
            group_name: req.body.group_name,
            created_by: loggedInUser.data.user_id,
            slug: slugify((req.body.group_name).toLowerCase())
        });

        // Save Group in the database
        groupDataPayload.save()
            .then(data => {
                res.send({ is_error: false, data: data });
            }).catch(err => {
               return res.status(500).send({
                    is_error: true,
                    message: err.message || "Some error occurred while creating the Group."
                });
            });
    }
};

// Get all DB facility groups
exports.getAllGroups = async (req, res) => {
    try {
        const GroupData = await groupModel.find({ parent: { $eq: null } }).sort([["updatedAt",-1]]);
        res.send({ is_error: false, data: GroupData });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};
