var slugify = require('slugify')
const faqModel = require('../model/faq');

// Create and Save a new FAQ
exports.create = (req, res) => {
    console.log("faq Body data", req.body)
    // Validate request
    if (!(req.body.faq_title && req.body.faq_content)) {
        return res.status(400).send({"is_error": true , "message": "All input is required"});
      }

    // Create a FAQ
    const FAQ = new faqModel({
        faq_title: req.body.faq_title , 
        faq_content: req.body.faq_content,
        slug: slugify((req.body.faq_title).toLowerCase())
    });

    // Save FAQ in the database
    FAQ.save()
    .then(data => {
        res.send({is_error : false, data: data });
    }).catch(err => {
        return res.status(500).send({
            is_error : true,
            message: err.message || "Some error occurred while creating the FAQ."
        });
    });
};

// Retrieve and return all FAQs from the database.
exports.findAll = async (req, res) => {
    try {
        const FAQ = await faqModel.find({}).sort([["updatedAt",-1]]);
        res.send({is_error : false, data: FAQ});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a single FAQ with a id
exports.findOne = (req, res) => {
    faqModel.findById(req.params.id)
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found with id " + req.params.id
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving FAQ details with id " + req.params.id
        });
    });
};

// Find a single FAQ with a slug
exports.findFAQBySlug = (req, res) => {
    faqModel.findOne({'slug':req.params.slug})
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found for " + req.params.slug
            });            
        }
        res.send({is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found for  " + req.params.slug
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving FAQ for  " + req.params.slug
        });
    });
};

// Update a user identified by the id in the request
exports.update = (req, res) => {
    console.log("req.body", req.body);
    console.log("req.params", req.params)
    // Validate Request
    // if(!req.body.content) {
    //     return res.status(400).send({
    //         message: "Note content can not be empty"
    //     });
    // }

    // Find note and update it with the request body
    faqModel.findByIdAndUpdate(req.params.id, {
        faq_title: req.body.faq_title , 
        faq_content: req.body.faq_content,
        slug: slugify((req.body.faq_title).toLowerCase())
    }, {new: true})
    .then(response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found with id " + req.params.id
            });
        }
        res.send( { is_error : false, data: response });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error updating FAQ with id " + err
        });
    });
};

// Delete a FAQData with the specified id in the request
exports.delete = (req, res) => {
    faqModel.findByIdAndRemove(req.params.id)
    .then(responseData => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "FAQ deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "FAQ not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete FAQ with id " + req.params.id
        });
    });
};