var slugify = require('slugify')
const hotelModel = require('../model/hotel');
const mediaModel = require('../model/projectMedia');

const helper = require('../middleware/_helper');
const mediaUtils = require("../config/unlinkMedia");

const path = require("path");
var fs = require("fs");
const fse = require('fs-extra')

/// Create and Save a new Hotel
exports.create = (req, res) => {
    console.log("Hotel Body data", req.body)
    // Validate request
    if (!req.body.name) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Hotel Name." });
    }
    if (!req.body.company_id) {
        return res.status(400).send({ "is_error": true, "message": "Please select associated company." });
    }
    // Create a Hotel
    const hotelRecord = new hotelModel({
        name: req.body.name,
        about_us: req.body.about_us,
        email: req.body.email,
        phone: req.body.phone,
        address_line: req.body.address_line,
        country: req.body.country,
        state: req.body.state,
        city: req.body.city,
        zip_code: req.body.zip_code,
        company_id: req.body.company_id,
        slug: slugify((req.body.name).toLowerCase())
    });

    // Save Hotel in the database
    hotelRecord.save()
        .then(data => {
            res.send({ is_error: false, data: data });
        }).catch(err => {
            return res.status(500).send({
                is_error: true,
                message: err.message || "Some error occurred while creating the Hotel."
            });
        });
};

// Retrieve and return all hotels from the database.
exports.findAll = async (req, res) => {
    try {
        const page = await hotelModel.find({}).sort([["updatedAt", -1]]);
        res.send({ is_error: false, data: page });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Find a single Hotel Details with a id
exports.findOne = (req, res) => {
    hotelModel.findById(req.params.id)
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving hotel details with id " + req.params.id
            });
        });
};

// Find a single hotel with a slug
exports.findHotelBySlug = (req, res) => {
    hotelModel.findOne({ 'slug': req.params.slug })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found for " + req.params.slug
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found for  " + req.params.slug
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Hotel details for  " + req.params.slug
            });
        });
};

// Update Hotel details
exports.update = (req, res) => {

    console.log("req.body", req.body)
    // Validate request
    if (!req.body.name) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Hotel Name." });
    }
    if (!req.body.company_id) {
        return res.status(400).send({ "is_error": true, "message": "Please select associated company." });
    }
    // Create a Hotel
    const hotelRecord = {
        name: req.body.name,
        about_us: req.body.about_us,
        email: req.body.email,
        phone: req.body.phone,
        address_line: req.body.address_line,
        country: req.body.country,
        state: req.body.state,
        city: req.body.city,
        zip_code: req.body.zip_code,
        company_id: req.body.company_id,
        slug: slugify((req.body.name).toLowerCase())
    };


    // Find Hotel and update it with the request body
    hotelModel.findByIdAndUpdate(req.params.id, hotelRecord, { new: true })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating Hotel with id " + err
            });
        });
};

// Delete a Hotel with the specified id in the request
exports.delete = (req, res) => {
    hotelModel.findByIdAndRemove(req.params.id)
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, message: "Hotel deleted successfully!" });
        }).catch(err => {
            if (err.kind === 'ObjectId' || err.name === 'NotFound') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Could not delete Hotel with id " + req.params.id
            });
        });
};

// Change project status
exports.changeStatus = async (req, res) => {

    await hotelModel.findByIdAndUpdate(req.params.hotelId, {
        is_active: req.body.is_active
    }, { new: true })
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Hotel Details."
                });
            }
            const notifyMsg = req.body.is_active ? 'Opened' : 'Closed';
            res.send({ 'message': 'Hotel has been marked as' + ' ' + notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the Hotel status."
            });
        });
};