var slugify = require('slugify')
const hotelBranchModel = require('../model/hotel_branch');
const hotelModel = require('../model/hotel');

/// Create and Save a new Hotel
exports.create = async (req, res) => {
    console.log("Hotel branch Body data", req.body)
    // Validate request
    if (!req.body.name) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Hotel Branch name." });
    }
    if (!req.body.hotel_id) {
        return res.status(400).send({ "is_error": true, "message": "Please select Hotel." });
    }
    const hotelDetails = await hotelModel.findOne({_id: req.body.hotel_id });
    if(!hotelDetails){
        return res.status(400).send({ "is_error": true, "message": "Please select the Hotel.Please check either Hotel does not exist or you have selected incorrect hotel reference." });
    }
    // Create a Hotel Branch
    const hotelRecord = new hotelBranchModel({
        name: req.body.name,
        hotel_id: req.body.hotel_id,
        branch_code: req.body.branch_code,
        slug: slugify((req.body.name).toLowerCase())
    });

    // Save Hotel Branch in the database
    hotelRecord.save()
        .then(data => {
            res.send({ is_error: false, data: data });
        }).catch(err => {
            return res.status(500).send({
                is_error: true,
                message: err.message || "Some error occurred while creating the Hotel Branch."
            });
        });
};

// Retrieve and return all hotels branches from the database.
exports.findAll = async (req, res) => {
    try {
        const page = await hotelBranchModel.find({}).sort([["updatedAt", -1]]);
        res.send({ is_error: false, data: page });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Find a single Hotel Details with a id
exports.findOne = (req, res) => {
    hotelBranchModel.findById(req.params.id)
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving hotel details with id " + req.params.id
            });
        });
};

// Find a single hotel with a slug
exports.findHotelBySlug = (req, res) => {
    hotelBranchModel.findOne({ 'slug': req.params.slug })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found for " + req.params.slug
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel details not found for  " + req.params.slug
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Hotel details for  " + req.params.slug
            });
        });
};

// Update Hotel details
exports.update = (req, res) => {

    console.log("req.body", req.body)
    // Validate request
    if (!req.body.name) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Hotel Name." });
    }

    // Create a Hotel
    const hotelRecord = {
        name: req.body.name,
        about_us: req.body.about_us,
        email: req.body.email,
        phone: req.body.phone,
        address: req.body.address_line,
        country: req.body.country,
        state: req.body.state,
        city: req.body.city,
        zip_code: req.body.zip_code,
        company_logo: req.body.company_logo,
        slug: slugify((req.body.name).toLowerCase())
    };


    // Find Hotel and update it with the request body
    hotelBranchModel.findByIdAndUpdate(req.params.id, hotelRecord, { new: true })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating Hotel with id " + err
            });
        });
};

// Delete a Hotel with the specified id in the request
exports.delete = (req, res) => {
    hotelBranchModel.findByIdAndRemove(req.params.id)
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, message: "Hotel deleted successfully!" });
        }).catch(err => {
            if (err.kind === 'ObjectId' || err.name === 'NotFound') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Could not delete Hotel with id " + req.params.id
            });
        });
};