var slugify = require('slugify')
const reportModel = require('../model/reports');
const mediaModel = require('../model/reportsMedia');
const projectModel = require('../model/projects');

const emailCtrl = require('../controllers/email.controller');
const email_templates = require('../config/email_template_ids');

const helper = require('../middleware/_helper');
const mediaUtils = require("../config/unlinkMedia");

const path = require("path");
var fs = require("fs");
const fse = require('fs-extra')
const moment = require('moment');

// Create and Save a new project
exports.create = (req, res) => {
    console.log("reports Body data", req.body)

    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);

    // Create report payload
    const reportObj = new reportModel(
      {
        report_title: req.body.report_title,
        project_start_date: req.body.project_start_date,
        onsite_material_confirmed: req.body.onsite_material_confirmed,
        inspection_date: req.body.inspection_date,
        weather: req.body.weather,
        crew_size: req.body.crew_size,
        area_completed_onday: req.body.area_completed_onday,
        completion_percentage: req.body.completion_percentage,
        forecasted_completion_date: req.body.forecasted_completion_date,
        work_description: req.body.work_description,
        projectId: req.body.projectId,
        additional_remark: req.body.additional_remark ? req.body.additional_remark : '',
        is_deleted: false,
        inspector_id: loggedInUser.data.user_id,
        created_by: loggedInUser.data.user_id,
      
      });
      const filesMetaData = JSON.parse(req.body.filesMetaData);
      console.log("Report Add filesMetaData",filesMetaData)
    // Save Reports in the database
    reportObj.save()
    .then(async data => {
        
        let media = [];
        const mediaRootPath = "public/uploads/reports/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                 const filedesc = await filesMetaData.filter (item => { return item.customFile === mediaFile.originalname })
                    media.push({
                        path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                        filename: mediaFile.filename,
                        ref_id: data._id,
                        type: mediaFile.fieldname,
                        mimetype: mediaFile.mimetype,
                        description: filedesc.length > 0 ? filedesc[0].description : '',
                        extn: (mediaFile.filename.split('.').pop()).toLowerCase()
                    });
                })

            } else {
                console.log("Else condition block")
            }
        })
        if(!data) {
            // remove all recently uploaded images from directory
            media.forEach(element => {
                mediaUtils.unlink(element.path);
            });
            return res.status(404).send({
                is_error : true,
                message: "Error while submitting the Report."
            });
        }
        console.log("media object", media)
        // store all images,documents and videos
        await mediaModel.insertMany(media);

        res.send({is_error : false, data: data });
    }).catch(err => {
        // delete all uploaded report media files from directory
        const mediaRootPath = "public/uploads/reports/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    // call util method to remove file from location
                    mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                })
            }
        })
        return res.status(500).send({
            is_error : true,
            message: err.message || "Some error occurred while saving report."
        });
    });
};

// Retrieve and return all reports from the database.
exports.findAll = async (req, res) => {
    try {
        const report = await reportModel.find({is_deleted: false})
        .populate([ {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
            populate: [{ path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role'] }, 
            { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role'] },
            { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role'] }]
        }])
        .populate([{path:'inspector_id', select:['first_name','last_name']}])
        .populate([{path:'created_by', select:['first_name','last_name']}])
        .populate([{path:'updated_by', select:['first_name','last_name']}])
        .sort([["createdAt",-1]]);
        res.send({is_error : false, data: report});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Retrieve and return all reports for a project.
exports.findReportsByProjectId = async (req, res) => {
    try {
        const report = await reportModel.find({is_deleted: false , projectId: req.params.id})
        .populate([{
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
            populate: [{ path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role'] }, 
            { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role'] },
            { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role'] }]
        }])
        .populate([{path:'inspector_id', select:['first_name','last_name']}])
        .populate([{path:'created_by', select:['first_name','last_name']}])
        .populate([{path:'updated_by', select:['first_name','last_name']}])
        .sort([["createdAt",-1]]);
        res.send({is_error : false, data: report});
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Retrieve and return all reports for logged in user
exports.findMyReports = async (req, res) => {
    try {
        const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
        console.log("loggedInUser", loggedInUser)
        // find all assigned projects of loggedin user
        let query = {is_deleted: false, 
            $or: [
                { 'assignedInspector': loggedInUser.data.user_id },
                {'assignedManufacturers': loggedInUser.data.user_id},
                {'assignedContractor': loggedInUser.data.user_id},
                {'assignedOwner': loggedInUser.data.user_id},
                {'created_by': loggedInUser.data.user_id }
        ] } ;
        console.log("final Query", query)
        const projects = await projectModel.find(query)
        var projectIds = await projects.map(function (item) {
            return item['_id'];
          });
        if(projectIds && projectIds.length != 0){
            const report = await reportModel.find({is_deleted: false , projectId: {$in:projectIds}})
            .populate([{
                path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
                populate: [{ path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role'] }, 
                { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role'] },
                { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role'] }]
            }])
            .populate([{path:'inspector_id', select:['first_name','last_name']}])
            .populate([{path:'created_by', select:['first_name','last_name']}])
            .populate([{path:'updated_by', select:['first_name','last_name']}])
            .sort([["createdAt",-1]]);
            res.send({is_error : false, data: report});
        }else{
            res.send({is_error : false, data: []});
        }
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Retrieve and return all reports by user id
exports.getReportsByUserId = async (req, res) => {
    try {
        // find all assigned projects of loggedin user
        let query = {is_deleted: false, 
            $or: [
                { 'assignedInspector': req.params.id },
                {'assignedManufacturers': req.params.id},
                {'assignedContractor': req.params.id},
                {'assignedOwner': req.params.id},
                {'created_by': req.params.id }
        ] } ;
        console.log("final Query", query)
        const projects = await projectModel.find(query)
        var projectIds = await projects.map(function (item) {
            return item['_id'];
          });
        if(projectIds && projectIds.length != 0){
            const report = await reportModel.find({is_deleted: false , projectId: {$in:projectIds}})
            .populate([{
                path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
                populate: [{ path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role'] }, 
                { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role'] },
                { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role'] }]
            }])
            .populate([{path:'inspector_id', select:['first_name','last_name']}])
            .populate([{path:'created_by', select:['first_name','last_name']}])
            .populate([{path:'updated_by', select:['first_name','last_name']}])
            .sort([["createdAt",-1]]);
            res.send({is_error : false, data: report});
        }else{
            res.send({is_error : false, data: []});
        }
    } catch (error) {
        console.log(error);
        return res.send({"is_error": true , "message": "An error occured : " + error});
    }
  };

// Find a single report details
exports.findOne = async (req, res) => {
    reportModel.findOne({_id:req.params.id, is_deleted:false})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line'],
            populate: [{ path: 'assignedManufacturers', select:['first_name','last_name','company_name','email','role'] }, 
            { path: 'assignedContractor', select:['first_name','last_name','company_name','email','role'] },
            { path: 'assignedOwner', select:['first_name','last_name','company_name','email','role'] }],
            // populate: { path: 'assignedContractor', select:['first_name','last_name','company_name'] },
            // populate: { path: 'assignedOwner', select:['first_name','last_name','company_name'] }
        }
    ])
    .populate([{path:'inspector_id', select:['first_name','last_name']}])
    .populate([{path:'created_by', select:['first_name','last_name']}])
    .populate([{path:'updated_by', select:['first_name','last_name']}])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });            
        }
        const projectMedia = await mediaModel.find({ref_id: req.params.id, deleted: false});
        // console.log("projectMedia", projectMedia);
        response.mediaFiles = projectMedia ;
        res.send({is_error : false, data: response, mediaFiles: projectMedia });
    }).catch(err => {
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.params.id
        });
    });
};

// Update a Report Details
exports.update = (req, res) => {
    // console.log("req.body", req.files);
    // console.log("req.body", req.body)
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);
    const payload = {
      report_title: req.body.report_title,
      onsite_material_confirmed: req.body.onsite_material_confirmed,
      inspection_date: req.body.inspection_date,
      weather: req.body.weather,
      crew_size: req.body.crew_size,
      area_completed_onday: req.body.area_completed_onday,
      completion_percentage: req.body.completion_percentage,
      forecasted_completion_date: req.body.forecasted_completion_date,
      work_description: req.body.work_description,
      additional_remark: req.body.additional_remark ? req.body.additional_remark : '',
      inspector_id: loggedInUser.data.user_id,
      updated_by: loggedInUser.data.user_id,
    };
    const filesMetaData = JSON.parse(req.body.filesMetaData);
    const existingFilesData = JSON.parse(req.body.existingFilesData);

     console.log("filesMetaData",filesMetaData);
     console.log("existingFilesData", existingFilesData)
    // Find report and update it with the request body
    reportModel.findByIdAndUpdate(req.params.id, payload , {new: true})
    .then(async response => {
        let media = [];
        const mediaRootPath = "public/uploads/reports/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                 const filedesc = await filesMetaData.filter (item => { return item.customFile === mediaFile.originalname })
                    media.push({
                        path: mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename,
                        filename: mediaFile.filename,
                        ref_id: response._id,
                        type: mediaFile.fieldname,
                        mimetype: mediaFile.mimetype,
                        description: filedesc.length > 0 ? filedesc[0].description : '',
                        extn: (mediaFile.filename.split('.').pop()).toLowerCase()
                    });
                })

            } else {
                console.log("Else condition block")
            }
        })

        if(!response) {
            // remove all recently uploaded images from directory
            media.forEach(element => {
                mediaUtils.unlink(element.path);
            });
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });
        }
        // store all images,documents and videos
        await mediaModel.insertMany(media);
        // Remove all the removed media from directory and Media Collection
        if (req.body.existingFilesData) {
            const filesTobeRemoved = JSON.parse(req.body.existingFilesData);
            await filesTobeRemoved.forEach(element => {
                if(element.deleted){
                    mediaUtils.unlink(element.path);
                    // delete record from Media collection
                    mediaModel.findByIdAndUpdate(element._id,element).exec();
                }else{
                    // only update the records with updated data of description
                    mediaModel.findByIdAndUpdate(element._id,element).exec();
                }
            });
        }
        res.send( { is_error : false, data: response });
    }).catch(err => {
        // delete all uploaded project media files from directory
        const mediaRootPath = "public/uploads/reports/";
        const mediaKey = Object.keys(req.files);
        mediaKey.forEach(async key => {
            if (req.files[key].length && req.files[key].length > 0) {
                // multiple files
                const projectMediaFiles = req.files[key];
                await projectMediaFiles.forEach(async mediaFile => {
                    // call util method to remove file from location
                    mediaUtils.unlink(mediaRootPath + mediaFile.fieldname + '/' + mediaFile.filename);
                })
            }
        })

        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error updating Report details with id " + err
        });
    });
};

// Delete a report with the specified id in the request
exports.delete = (req, res) => {
    // reportModel.findByIdAndRemove(req.params.id)
    reportModel.findByIdAndUpdate(req.params.id, {is_deleted: true})
    .then(responseData => {
        if(!responseData) {
            return res.status(404).send({
                is_error : true,
                message: "Report Details not found with id " + req.params.id
            });
        }
        res.send({is_error : false, message: "Report deleted successfully!"});
    }).catch(err => {
        if(err.kind === 'ObjectId' || err.name === 'NotFound') {
            return res.status(404).send({
                is_error : true,
                message: "Report Details not found with id " + req.params.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Could not delete Report with id " + req.params.id
        });
    });
};

// Change project status
exports.changeStatus = async (req, res) => {
    const loggedInUser = helper.getCurrentUser(req.headers["x-access-token"]);

    await reportModel.findByIdAndUpdate(req.params.projectId, {
        is_active: req.body.is_active,
        updated_by: loggedInUser.data.user_id
    }, { new: true })
        .then(projectData => {
            if (!projectData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Project Details."
                });
            }
            const notifyMsg = req.body.is_active ? 'Opened' : 'Closed';
            res.send({'message': 'Project has been marked as' +' '+ notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Project details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the project status."
            });
        });
};


// Email Report to Selected users
exports.sendReport = async (req, res) => {
    console.log("req.body", req.body)
    if(!req.body.id){
        return res.status(400).send({ "is_error": true, "message": "Please select the correct report." });
    }
    if(req.body.to_users && req.body.to_users.lenght == 0){
        return res.status(400).send({ "is_error": true, "message": "Please select the email recipient" });
    }
    reportModel.findOne({_id:req.body.id})
    .populate([
        {
            path:'projectId', select:['name', 'country', 'city','state', 'zip_code', 'address_line','total_size'],
            populate: { path: 'assignedOwner', select:['first_name','last_name','company_name'] }
        }
    ])
    .populate([{path:'inspector_id', select:['first_name','last_name']}])
    .populate([{path:'created_by', select:['first_name','last_name']}])
    .populate([{path:'updated_by', select:['first_name','last_name']}])
    .then(async response => {
        if(!response) {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.body.id
            });            
        }
    let inspection_photos = await mediaModel.find({ref_id: req.body.id, deleted: false,type:'inspection_photos' });
    let inspection_videos = await mediaModel.find({ref_id: req.body.id, deleted: false,type:'inspection_videos' });
    let inspection_documents = await mediaModel.find({ref_id: req.body.id, deleted: false,type:'supporting_documents'});
    const google_earth = await mediaModel.find({ref_id: req.body.id, deleted: false,type:'google_earth'});

    inspection_photos =  inspection_photos.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })
    inspection_videos =  inspection_videos.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })
    inspection_documents =  inspection_documents.map(item=>{
        item.path = process.env.PUBLIC_BASE_URL+ '/' + item.path ;
        return item ;
    })

    var userEmails = await req.body.to_users.map(function (user) {
        return user['email'];
      });
    userEmails.push('shivam201065@gmail.com')
    console.log("userEmails", userEmails)
    //  Write code to send email to users 
    const mailTemplateContent = {
        // "subject":"OPM Report-"+ response.projectId.name + '- ' + moment(response.inspection_date).format('DD/MM/YYYY'),
        "subject": req.body.email_subject,
        "email_message": req.body.email_message,
        "inspection_date": moment(response.inspection_date).format('DD/MM/YYYY'),
        "material_confirmed": response.onsite_material_confirmed ? 'YES' : 'NO',
        "crew_size":response.crew_size,
        "area_completed_onday": response.area_completed_onday,
        "weather_condition":response.weather,
        "percentage_completion":response.completion_percentage,
        "report_description": response.work_description,
        "remarks":response.additional_remark,
        "documents_count":inspection_documents.length,
        "inspection_photos_count": inspection_photos.length,
        "inspection_video_count": inspection_videos.length,
        "google_photo_url":google_earth.length >0 ? process.env.PUBLIC_BASE_URL + '/' + google_earth[0].path : '',
        "project_id":response.projectId._id,
        "project_name": response.projectId.name,
        "location": response.projectId.address_line + response.projectId.city + response.projectId.state + response.projectId.city + response.projectId.zip_code,
        "project_size":response.projectId.total_size,
        "start_date": moment(response.project_start_date).format('DD/MM/YYYY HH:mm:ss'),
        "inspection_photos": inspection_photos ,
        "inspection_videos": inspection_videos,
        "inspection_documents": inspection_documents
    }

    const emailData = {
        msg: {
            to: userEmails,
            from: 'Winston@roofingprojects.com', // Use the email address or domain you verified above
            template_id: email_templates.REPORT_PROGRESS_SUMMARY,
            dynamic_template_data: mailTemplateContent
          },
        userDetails: {}
    }
    // send Email to User with report details.
    emailCtrl.sendEmail(emailData);

    res.send({is_error : false, data: response });
    }).catch(err => {
        console.log("error", err)
        if(err.kind === 'ObjectId') {
            return res.status(404).send({
                is_error : true,
                message: "Report not found with id " + req.body.id
            });                
        }
        return res.status(500).send({
            is_error : true,
            message: "Error retrieving report details with id " + req.body.id
        });
    });
};