var slugify = require('slugify')
const roomModel = require('../model/rooms');
const mediaModel = require('../model/projectMedia');

const helper = require('../middleware/_helper');
const mediaUtils = require("../config/unlinkMedia");

const path = require("path");
var fs = require("fs");
const fse = require('fs-extra')

/// Create and Save a new Room Details
exports.create = (req, res) => {
    console.log("Room Body data", req.body)
    // Validate request
    if (!req.body.name) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Room Title." });
    }
    if (!req.body.hotel_id) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Hotel Name." });
    }
    if (!req.body.priceList) {
        return res.status(400).send({ "is_error": true, "message": "Please Provide Room Price" });
    }
    if (req.body.priceList && req.body.priceList.length == 0) {
        return res.status(400).send({ "is_error": true, "message": "Please Provide Room Price" });
    }
    // Create a Room Payload
    const roomPayload = new roomModel({
        name: req.body.name,
        is_available: req.body.is_available,
        hotel_id: req.body.hotel_id,
        priceList: JSON.parse(req.body.priceList),
        description: req.body.description,
        terms_conditions: req.body.terms_conditions,
        facilities: [],
        cat_code: (req.body.cat_code).toUpperCase(),
        room_cat_group: req.body.room_cat_group,
        love_nest: req.body.love_nest,
        on_request_booking: req.body.on_request_booking,
        slug: slugify((req.body.name).toLowerCase())
    });

    // Save Room in the database
    roomPayload.save()
        .then(data => {
            res.send({ is_error: false, data: data });
        }).catch(err => {
            return res.status(500).send({
                is_error: true,
                message: err.message || "Some error occurred while creating the Room."
            });
        });
};

// Retrieve and return all room from the database.
exports.findAll = async (req, res) => {
    try {
        const rooms = await roomModel.find({})
            .populate({ path: 'hotel_id', select: ["name"] })
            .sort([["updatedAt", -1]]);
        res.send({ is_error: false, data: rooms });
    } catch (error) {
        console.log(error);
        return res.send({ "is_error": true, "message": "An error occured : " + error });
    }
};

// Find a single Room Details with room id
exports.findOne = (req, res) => {
    roomModel.findById(req.params.id)
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Room details with id " + req.params.id
            });
        });
};

// Find a single Room with a slug
exports.findRoomBySlug = (req, res) => {
    roomModel.findOne({ 'slug': req.params.slug })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found for " + req.params.slug
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found for  " + req.params.slug
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error retrieving Room details for  " + req.params.slug
            });
        });
};

// Update Room details
exports.update = (req, res) => {

    console.log("req.body", req.body)
    // Validate request
    if (!req.body.name) {
        return res.status(400).send({ "is_error": true, "message": "Please provide Room Category." });
    }
    if (!req.body.hotel_id) {
        return res.status(400).send({ "is_error": true, "message": "Please select Hotel." });
    }
    if (!req.body.priceList) {
        return res.status(400).send({ "is_error": true, "message": "Please Provide Room Price" });
    }
    if (req.body.priceList && req.body.priceList.length == 0) {
        return res.status(400).send({ "is_error": true, "message": "Please Provide Room Price" });
    }
    // Create a Room Payload
    const roomPayload = {
        name: req.body.name,
        is_available: req.body.is_available,
        hotel_id: req.body.hotel_id,
        priceList: JSON.parse(req.body.priceList),
        description: req.body.description,
        terms_conditions: req.body.terms_conditions,
        facilities: [],
        cat_code: (req.body.cat_code).toUpperCase(),
        room_cat_group: req.body.room_cat_group,
        love_nest: req.body.love_nest,
        on_request_booking: req.body.on_request_booking,
        slug: slugify((req.body.name).toLowerCase())
    };


    // Find room and update it with the request body
    roomModel.findByIdAndUpdate(req.params.id, roomPayload, { new: true })
        .then(response => {
            if (!response) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, data: response });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Hotel not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating Room with id " + err
            });
        });
};

// Delete a Room with the specified id in the request
exports.delete = (req, res) => {
    roomModel.findByIdAndRemove(req.params.id)
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Room not found with id " + req.params.id
                });
            }
            res.send({ is_error: false, message: "Room deleted successfully!" });
        }).catch(err => {
            if (err.kind === 'ObjectId' || err.name === 'NotFound') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room not found with id " + req.params.id
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Could not delete Room with id " + req.params.id
            });
        });
};

// Change Room  status
exports.changeStatus = async (req, res) => {
    console.log("room Id", req.params.id)
    await roomModel.findByIdAndUpdate(req.params.id, {
        is_available: req.body.is_available
    }, { new: true })
        .then(responseData => {
            if (!responseData) {
                return res.status(404).send({
                    is_error: true,
                    message: "Invalid Room Details."
                });
            }
            const notifyMsg = req.body.is_active ? 'Available' : 'Unavailable';
            res.send({ 'message': 'Room has been marked as' + ' ' + notifyMsg });
        }).catch(err => {
            if (err.kind === 'ObjectId') {
                return res.status(404).send({
                    is_error: true,
                    message: "Room details not found with provided Id."
                });
            }
            return res.status(500).send({
                is_error: true,
                message: "Error updating the Room status."
            });
        });
};