const jwt = require("jsonwebtoken");

const config = process.env;

exports.getCurrentUser = (token) => {

  if (!token) {
    return ({is_error: true, message:"Access denied."});
  }
  try {
    const decoded = jwt.verify(token, config.TOKEN_KEY);
    return ({is_error: false, data: decoded});
  } catch (err) {
    return ({is_error: true, message:"Not Authorized."});
  }
};