const jwt = require("jsonwebtoken");
const User = require("../model/user");

const config = process.env;

const verifyToken = async (req, res, next) => {
 
  const token =
    req.body.token || req.query.token || req.headers["x-access-token"];
    console.log("middleware", token)
  if (!token) {
    return res.status(403).send({is_error: true, message:"Access denied."});
  }
  try {
    const decoded = jwt.verify(token, config.TOKEN_KEY);
    req.user = decoded;
    console.log("middleware auth verified", decoded);
    const user = await User.findOne({_id: decoded.user_id , email: decoded.email.toLowerCase() });
    if (user && !user.is_active) {
      // throw new Error({"is_error": true , "message": "Your Account is Inactive. Please contact Administrator." })
      return res.status(409).send({"type":"PROFILE_INACTIVE","is_error": true , "message": "Your Account is Inactive. Please contact Administrator." });
      // throw new Error('BROKEN')
    }
  } catch (err) {
    return res.status(401).send({is_error: true, message:"Invalid Token"});
  }
  return next();
};

module.exports = verifyToken;