const mongoose = require("mongoose");

const CategorySchema = new mongoose.Schema({
  name: {
    type: String,
    required: true,
    trim: true,
  },
  slug: {
    type: String,
    required: true,
    trim: true,
  },
  category_code: {
    type: String,
    required: true,
    trim: true,
  },
  created_by: { type: mongoose.Schema.Types.ObjectId, ref: 'user' },
  parent: {
    type: mongoose.Schema.Types.ObjectId,
    default: null,
    ref: 'category'
  }
}, {
  timestamps: true
});

module.exports = mongoose.model("room_category", CategorySchema);