const mongoose = require("mongoose");

const companySchema = new mongoose.Schema({
  company_name: {type: String, required: true, trim: true},
  company_logo: { type: String, default: '' },
  email: {type: String, required: true, trim: true},
  phone: { type: String },
  country: { type: String },
  state: { type: String },
  city: { type: String },
  zip_code: { type: String },
  address_line: {type: String},
  is_active: { type: Boolean, default: true },
  user_id: { type: mongoose.Schema.Types.ObjectId, ref: 'user'},
  about_us: { type: String, default: '' },
  privacy_policy: { type: String, default: '' },
  terms_and_conditions: { type: String, default: '' },
  is_deleted: {type: Boolean , default: false}

}, {
  timestamps: true
});

module.exports = mongoose.model("company", companySchema);