const mongoose = require("mongoose");

const deviceTokenSchema = new mongoose.Schema({
  registrationToken: {
    type: String,
    required: true,
    trim: true,
    unique: true
  },
  deviceType: {type: String, required: true}, // android , ios
  user_id: { type: mongoose.Schema.Types.ObjectId, ref: 'user' }
},  {
  timestamps: true
});
module.exports = mongoose.model("deviceToken", deviceTokenSchema);