const mongoose = require("mongoose");

const FacilitiesSchema = new mongoose.Schema({
  name: { type: String, required: true, trim: true },
  facility_type: { type: mongoose.Schema.Types.ObjectId, ref: 'facility_group'},
  description: { type: String, trim: true , default:''},
  created_by: { type: mongoose.Schema.Types.ObjectId, ref: 'user' },
  parent: {
    type: mongoose.Schema.Types.ObjectId,
    default: null,
    ref: 'facility'
  },
  is_active: { type: Boolean , default: true}
}, {
  timestamps: true
});

module.exports = mongoose.model("facility", FacilitiesSchema);