const mongoose = require("mongoose");

const hotelSchema = new mongoose.Schema({
  name: {type: String, required: true, trim: true},
  slug: {
    type: String,
    required: true,
    trim: true,
    unique: true
  },
  company_id: {type: mongoose.Schema.Types.ObjectId, ref: 'company' , required:true },
  company_logo: { type: String, default: '' },
  email: {type: String, required: true, trim: true},
  phone: { type: String },
  country: { type: String },
  state: { type: String },
  city: { type: String },
  zip_code: { type: String },
  address_line: {type: String},
  is_active: { type: Boolean, default: true },
  user_id: { type: mongoose.Schema.Types.ObjectId, ref: 'user'},
  about_us: { type: String, default: '' },
  checkIn: { type: Date },
  checkOut: { type: Date },
}, {
  timestamps: true
});

module.exports = mongoose.model("hotel", hotelSchema);