const mongoose = require("mongoose");

const hotelBranchSchema = new mongoose.Schema({
  name: {type: String, required: true, trim: true},
  branch_code: {type: String, required: true, trim: true, unique: true},
  slug: { type: String, required: true, trim: true, unique: true },
  hotel_id: { type: mongoose.Schema.Types.ObjectId, ref: 'hotel'},
  is_active: { type: Boolean, default: true },
}, {
  timestamps: true
});

module.exports = mongoose.model("hotel_branch", hotelBranchSchema);