const mongoose = require("mongoose");

const OTPSchema = new mongoose.Schema({
  otpvalue: {
    type: String,
    required: true,
    trim: true,
    unique: true
  },
  email: {
    type: String,
    required: true,
    trim: true,
    unique: true
  },
  user_id: { type: mongoose.Schema.Types.ObjectId, ref: 'user' },
  otp_verfied: {type: Boolean , default: false }
  // expireAt:{type: Date , required: true, index:{expires:'5m'}}
},  {
  timestamps: true
});
// OTPSchema.index( { "expireAt": 1 }, { expireAfterSeconds: 0 } );

module.exports = mongoose.model("otp", OTPSchema);