const mongoose = require("mongoose");

const pageSchema = new mongoose.Schema({
  page_title: {
    type: String,
    required: true,
    trim: true,
    unique: true
  },
  page_content: { type: String },
  is_active: {type: Boolean, default: true},
  slug: {
    type: String,
    required: true,
    trim: true,
    unique: true
  }
}, {
  timestamps: true
});

module.exports = mongoose.model("page", pageSchema);