const mongoose = require("mongoose");

const paymentIntentSchema = new mongoose.Schema({
  template_id: { type: mongoose.Schema.Types.ObjectId, ref: 'template' },
  clientSecret: {type: String , required:true},
  userId: { type: mongoose.Schema.Types.ObjectId, ref: 'user' },
  templateData_snapshot: {}, //hold template details
  userData_snapshot: {} ,// this will hold user details
  payment_status: { type : String , required: true, default:'INITIATED'}, //INITIATED , FAILED, COMPLETED

}, {
  timestamps: true
});

module.exports = mongoose.model("paymentIntent", paymentIntentSchema);
