const mongoose = require("mongoose");

const roomSchema = new mongoose.Schema({
  name: { type: String, required: true, trim: true },
  slug: { type: String, required: true, trim: true,unique: true},
  is_available: { type: Boolean, default: true },
  hotel_id: { type: mongoose.Schema.Types.ObjectId, ref: 'hotel'},
  price: {type : Number, default: 0.0 },
  priceList: [{
    startDate: {type: Date},
    endDate: {type: Date},
    price: {type: Number , default: 0}
  }],
  description: { type: String, default: '' },
  terms_conditions: { type: String, default: '' },
  facilities: [{type: mongoose.Schema.Types.ObjectId, ref: 'hotel'}],
  room_cat_group:{ type: String, trim: true,default:'' },
  cat_code:{ type: String, trim: true,default:'' },
  love_nest:{ type: Boolean, default: false },
  on_request_booking: {type: Boolean, default: false},
  checkIn: { type: Date , default: null },
  checkOut: { type: Date , default: null},
}, {
  timestamps: true
});

module.exports = mongoose.model("room", roomSchema);