const mongoose = require("mongoose");

const templateCategorySchema = new mongoose.Schema({
  name: {
    type: String,
    required: true,
    trim: true,
    unique: true
  },
  is_active: {type: Boolean, default: true},
  slug: {
    type: String,
    required: true,
    trim: true,
    unique: true
  }
}, {
  timestamps: true
});

module.exports = mongoose.model("template_category", templateCategorySchema);