const mongoose = require("mongoose");

const transactionSchema = new mongoose.Schema({
  template_id: { type: mongoose.Schema.Types.ObjectId, ref: 'template' },
  transactionId: {type: String , required:true},
  payment_method: {type: String , required:true},
  clientSecret: {type: String , required:true},
  amount: {type : Number, required: true},
  currency: {type : String, required: true},
  purchasedBy: { type: mongoose.Schema.Types.ObjectId, ref: 'user' },
  payment_status: { type : String , required: true},
  transaction_description: { type : String , required: true},
  payment_method_details: {}, //hold card details if payment made through card
  gateway_response: {}, // this will hold complete API response data.
  userSnapshot:{},
  templateSnapshot: {}
}, {
  timestamps: true
});

module.exports = mongoose.model("transaction", transactionSchema);

// "card": {
//   "brand": "Visa",
//   "checks": {},
//   "country": "US",
//   "expiryMonth": 2,
//   "expiryYear": 2024,
//   "funding": "credit",
//   "last4": "4242",
//   "networks": {
//   "available": [
//   "visa"
//   ],
//   "selectionMandatory": false
//   },
//   "threeDSecureUsage": {
//   "isSupported": true
//   }
//   }