const mongoose = require("mongoose");

const userSchema = new mongoose.Schema({
  first_name: {type: String,required: true,trim: true,default: null},
  last_name: {type: String,trim: true,default: null},
  email: {type: String,required: true,trim: true,unique: true},
  role: { type : String , default: 'APP_USER'}, // role: APP_USER, ADMIN 
  phone: { type: String },
  country: { type: String },
  state: { type: String },
  city: { type: String },
  zip_code: { type: String },
  address_line: {type: String},
  password: { type: String },
  is_admin: { type: Boolean, default: false },
  is_active: { type: Boolean, default: true },
  token: { type: String },
  profileImage: { type: String, default: '' }
}, {
  timestamps: true
});

module.exports = mongoose.model("user", userSchema);