const auth = require("../middleware/auth");
const express = require("express");
const app = express();
const companyCtrl = require('../controllers/company.controller');

var multer = require("multer");
const { storage } = require("../config/multer.config");
var upload = multer({ storage: storage });

    // Retrieve all company
    app.get("/", auth, companyCtrl.findAll);

    // Create a new company
    app.post('/add', upload.fields([{ name: "company_logo" }]), auth, companyCtrl.create);

    // Retrieve a single company with company_id
    app.get('/details/:id', auth, companyCtrl.findOne);

    // Update a company with company_id
    app.put('/update/:id', upload.fields([{ name: "company_logo" }]),auth, companyCtrl.update);

    // Delete a company with company_id
    app.delete('/delete/:id', auth, companyCtrl.delete);
    
    // change company status
    app.put('/changeStatus/:company_id', auth, companyCtrl.changeStatus);
    

module.exports = app;