const auth = require("../middleware/auth");

const express = require("express");

const app = express();
const faqCtrl = require('../controllers/faq.controller');

    // Retrieve all FAQs
    app.get("/",  faqCtrl.findAll);

    // Create a new FAQ
    app.post('/add', auth, faqCtrl.create);

    // Retrieve a single FAQ with id
    app.get('/:slug',  faqCtrl.findFAQBySlug);

    // Retrieve a single FAQ with id
    app.get('/details/:id',  faqCtrl.findOne);

    // Update a FAQ with id
    app.put('/update/:id', auth, faqCtrl.update);

    // Delete a FAQ with id
    app.delete('/delete/:id', auth, faqCtrl.delete);

module.exports = app;