const auth = require("../middleware/auth");

const express = require("express");

const app = express();
const pageCtrl = require('../controllers/page.controller');

    // Retrieve all pages
    app.get("/",  pageCtrl.findAll);

    // Create a new page
    app.post('/add', auth, pageCtrl.create);

    // Retrieve a single page with id
    app.get('/:slug',  pageCtrl.findPageBySlug);

    // Retrieve a single page with id
    app.get('/details/:id',  pageCtrl.findOne);

    // Update a page with id
    app.put('/update/:id', auth, pageCtrl.update);

    // Delete a page with id
    app.delete('/delete/:id', auth, pageCtrl.delete);

module.exports = app;