const auth = require("../middleware/auth");
const express = require("express");
const app = express();
const roomCtrl = require('../controllers/room.controller');

var multer = require("multer");
const { storage } = require("../config/multer.config");
var upload = multer({ storage: storage });

    // Retrieve all Rooms
    app.get("/", auth, roomCtrl.findAll);

    // Create a new Rooms
    app.post('/add', upload.fields([{ name: "room_photos" }]), auth, roomCtrl.create);

    // Retrieve a single room with id
    app.get('/:slug',  roomCtrl.findRoomBySlug);

    // Retrieve a single room with roomId
    app.get('/details/:id', auth, roomCtrl.findOne);

    // Update a Room with roomId
    app.put('/update/:id', upload.fields([{ name: "room_photos" }]),auth, roomCtrl.update);

    // Delete a Room with roomId
    app.delete('/delete/:id', auth, roomCtrl.delete);

    // change Room status
    app.put('/changeStatus/:id', auth, roomCtrl.changeStatus);

module.exports = app;