const auth = require("../middleware/auth");

const express = require("express");

const app = express();
const templatecategoryCtrl = require('../controllers/template.category.controller');

    // Retrieve all categories
    app.get("/",  templatecategoryCtrl.findAll);

    // Create a new category
    app.post('/add',  templatecategoryCtrl.create);

    // Retrieve a single category with id
    app.get('/:slug',  templatecategoryCtrl.findCategoryBySlug);

    // Retrieve a single category with id
    app.get('/details/:id',  templatecategoryCtrl.findOne);

    // Update a category with id
    app.put('/update/:id',  templatecategoryCtrl.update);

    // Delete a category with id
    app.delete('/delete/:id',  templatecategoryCtrl.delete);

module.exports = app;