const auth = require("../middleware/auth");
const userAuth = require("../middleware/userAuth");
const express = require("express");
const app = express();
const userCtrl = require('../controllers/user.controller');
// Admin Section APIS routes
    // Retrieve all Users
    app.get("/", auth, userCtrl.findAll);
    // Create a new User
    app.post('/add', auth, userCtrl.create);
    // Retrieve a single User with userId
    app.get('/details/:userId', auth, userCtrl.findOne);
    // Update a User with userId
    app.put('/update/:userId', auth, userCtrl.update);
    // Delete a User with userId
    app.delete('/delete/:userId', auth, userCtrl.delete);

// User Section API routes
    // Update logged in user profile details
    app.put('/my-profile/update', auth, userCtrl.updateMyAccount);
    // send contact us form
    app.post('/contact-us', auth, userCtrl.submitContactUsForm);
    // change Passowrd - My profile
    app.post('/changePassword', auth, userCtrl.changeMyPassword);
    // validate OTP - My profile
    app.post('/validate-otp', auth, userCtrl.validateOtp);
    // update Password- My profile
    app.post('/update-password', auth, userCtrl.updatePassword);
    app.post('/change-avatar', auth, userCtrl.changeProfilePic);
    // search user by email
    app.post('/findUser', auth, userCtrl.findUserByEmail);
    
    // Admin Profile Routes
    // change user status
    app.put('/change-status/:userId', auth, userCtrl.changeStatus);
    // Retrieve admin my account details
    app.get('/my-details', auth, userCtrl.myDetails);
    // change Passowrd - Admin user
    app.post('/admin/change-password', auth, userCtrl.changeAdminPassword);

module.exports = app;